#pragma once
#include <vector>
#include <string>
#include <map>
#include "xmlreader.h"
#include "threadlock.h"
#include "tools.h"

using namespace std;

extern wstring datapath;

class ContentItem {
public:
	ContentItem()
	{
		type = 0;
		version = 0;
		source = -1;
		c_type=6;

		i_Icon = false;
		i_BoxArt = false;
		i_SSCount = 0;
		Favourite = false;
		i_Background = false;

		discno = 0;
		disccn = 0;
		Complete = false;

	}

	bool CheckComplete()
	{
		// only show 360 and live games as incomplete
		if (type > 1)
			return true;

		if (title.empty()) return false;
		if (desc.empty()) return false;
		if (i_Icon == false) return false;
		if (i_BoxArt == false) return false;
		if (i_SSCount == 0) return false;
		if (genres.size() == 0) return false;
		return true;
	}

	wstring title;
	wstring path;
	int type;
	wstring packagetype;
	wstring desc;
	wstring id;
	wstring icon;
	wstring manuf;
	wstring mediaid;

	bool Complete;

	int version;
	int discno;
	int disccn;
	int source;

	bool Favourite;

	int c_type;

	wstring imagefolder;

	bool i_Icon;
	bool i_Background;
	bool i_BoxArt;
	int i_SSCount; 

	wstring shortpath;

	vector <wstring> genres;
};

class GenreItem {
public:
	GenreItem()
	{
	}

	wstring title;
	wstring icon;
};

typedef struct _ContentItems {
    int nItems;
    ContentItem *pItems[1000];
} ContentItems;

typedef struct _GenreItems {
    int nItems;
    GenreItem *pItems[1000];
} GenreItems;

struct TypePaths {
	vector<string> path;

};

class AltInfo {
public:
	AltInfo()
	{
		Version = 0;
	}
	int Version;
	wstring Title;
	wstring Desc;
	wstring Manuf;
	wstring BoxArt;
	wstring Background;
	wstring AltUrl;
	vector <wstring> Screenshots;
	vector <wstring> Genres;
};

class ContentList
{
public:
	vector<ContentItem*> Content;
	map<int,vector<GenreItem*>*> Genres;
	map<int,TypePaths*> Paths;
	map<wstring,ContentItem*> PathLookup;
	map<wstring,AltInfo*> AltInfos;

	int HorizOverscan;
	int VertOverscan;

	bool Loaded;
	bool AnyChanged;
	// thread loading progress
	wstring current;

	wstring sub1;
	int sub1ProgCur;
	int sub1ProgMax;

	wstring sub2;
	int sub2ProgCur;
	int sub2ProgMax;

	ContentList(void);
	~ContentList(void);

	void LoadConfig();
	void LoadContentXML();
	GenreItems* GetGenres(int type);
	void BuildGenreList();
	void SortAll();
	void Initialize();
	void SaveContentList();
	void MakeShortPath(ContentItem * item);
	ContentItems* GetItems(bool OnlyIncomplete = false, int Type = -1);
	void LoadAltInfo();
};

extern ContentList cl;
 